﻿using System;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Activation;
using System.ServiceModel.Web;

// The commented ServiceKnowType entries show how the types can be declared at the class level. Currently the types
// are declared in web.config.

namespace AjaxWebServicesDemo
{
    [ServiceContract]
    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    public class ComplexService
    {
        [OperationContract]
        //[ServiceKnownType(typeof(BusinessEntity))]
        //[ServiceKnownType(typeof(CustomerEntity))]
        //[ServiceKnownType(typeof(VendorEntity))]
        public BusinessEntity Save(BusinessEntity entity)
        {
            CustomerEntity customer = entity as CustomerEntity;
            if (customer != null)
            {
                customer.ApprovalDate = DateTime.Now;
            }

            VendorEntity vendor = entity as VendorEntity;
            if (vendor != null)
            {
                vendor.CreditRating = "A";
            }

            entity.Id = Guid.NewGuid().ToString();
            return entity;
        }
    }
}
